//
//  MCQueryCriteria.h
//  MCApplication
//
//  Created by Michael Clark on 07/09/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>



typedef enum _MCQueryCriteriaBooleanType {
    MCQueryCriteriaAndOrBooleanType		= 1,
    MCQueryCriteriaOrBooleanType,
	MCQueryCriteriaAndBooleanType,
	MCQueryCriteriaNoneBooleanType
} MCQueryCriteriaBooleanType;



@interface MCQueryCriteria : NSObject {
	NSMutableDictionary*     _config;
	
	NSArray*                 _relatedCriterias;
	NSString*                _subsetIdentifier;
}

- (id)initWithConfig: (NSDictionary*)aConfig;

- (BOOL)isRelationship;

- (NSArray*)relatedCriterias;
- (void)setRelatedCriterias: (NSArray*)criterias;

- (NSDictionary*)additionalConfig; // Returns nil - subclassers can override to return additional information to be used when creating the qualifier, or reconstituting the query view stack

- (BOOL)hideOperatorSelector;
- (NSArray*)operators;

- (NSString*)localizedDisplayString;
- (NSString*)localizedBreadCrumbTrailFromEntityNamed: (NSString*)entityName;

///// DERIVED ACCESSORS //////
- (NSString*)identifier;

- (BOOL)isHidden;

- (NSString*)entityName;
- (NSString*)displayStringKey;
- (NSString*)type;
- (NSString*)availability;

- (NSString*)keyPathIdentifier;

- (NSString*)keyPath;
- (BOOL)databaseDependent;


/// ATTRIBUTE SPECIFIC ///
- (NSString*)valueType;
- (NSDictionary*)valueOptions;
- (NSArray*)operatorIdentifiers;
- (MCQueryCriteriaBooleanType)booleanType;

- (NSString*)derivedKeyPath;
- (void)setDerivedKeyPath:(NSString*)aKeyPath;

- (NSString*)derivedDisplayString;
- (void)setDerivedDisplayString:(NSString*)aDisplayString;

/// RELATIONSHIP SPECIFIC ///
- (NSString*)relationshipEntityName;

///// ACCESSORS //////
- (NSDictionary *)config;
- (void)setConfig:(NSDictionary *)aConfig;

- (NSString *)subsetIdentifier;
- (void)setSubsetIdentifier:(NSString *)aSubsetIdentifier;

@end
